#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	/// <summary>
	/// Summary description for TransfusionRequirementsReport.
	/// </summary>
	[TestFixture]
	public class BOL_TransfusionRequirementsReport : BaseTest 
	{
		private BOL.TransfusionRequirementsReport _report;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			_report = new BOL.TransfusionRequirementsReport();
			_report.SetInitialBrokenRules("DlgTransfusionRequirementsReportCriteria");
		}	

		[Test]
		public void Ctor_Blank_Pass()
		{
			Assert.IsTrue(_report != null);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void IsCumulativeReport_Pass()
		{
			Assert.IsTrue(_report.IsCumulativeReport);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsCumulativeReport_Fail()
		{
		}

		[Test]
		public void GetTransfusionRequiremetsReport_Pass()
		{
			_report.IsCumulativeReport = true;
			DataTable dtReport = _report.GetTransfusionRequiremetsReport();
			Assert.IsTrue(dtReport.Columns.Count == 10);
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetTransfusionRequiremetsReport_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = null;
			DataTable dtReport = _report.GetTransfusionRequiremetsReport();
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass()
		{
			//Sends report directly to the printer
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail()
		{
			//Sends report directly to the printer
		}
	}
}

#endif

